﻿# Stellt die initiale Verbindung zu access.nosergroup.com her
# 
# (c) tom-agplv3@jig.ch
# Dieses Software untersteht der AGPLv3 Lizenz: https://choosealicense.com/licenses/agpl-3.0/
# 
# Wichtig: Bitte beachte die Datei: Hinweis AGPLv3 Lizenz.txt
# 
# 
# 001, 120730, tom-agplv3@jig.ch
# 002, 201013, tom-agplv3@jig.ch
# 	Der Chrome Cache wird nicht mehr gelöscht
# 003, 210120
# 	SendWait: Tastendrücke von Daten und die abschliessenden Steuertasten werden separat geschickt
# 

[CmdletBinding(SupportsShouldProcess)]
Param (
	# Wird vom cmd genützt
	# 0  Keine Pause am Ende
	# 1  Pause am Ende
	# >1 Sleep am Ende
	[Int]$WaitOnEnd = 1
)



# Die Tools einbinden
. ("{0}\Tom-Tools.ps1" -f [IO.Path]::GetDirectoryName([IO.Path]::GetDirectoryName([IO.Path]::GetDirectoryName((Get-PSCallStack | select -ExpandProperty ScriptName)))))



## Config

# Scripts referenzieren
$SetCiscoAnyConnectDefaultProfile_ps1 = ("{0}\Set-CiscoAnyConnect-DefaultProfile.ps1" -f [IO.Path]::GetDirectoryName([IO.Path]::GetDirectoryName([IO.Path]::GetDirectoryName((Get-PSCallStack | select -ExpandProperty ScriptName)))))
If (-not (Test-Path -LiteralPath $SetCiscoAnyConnectDefaultProfile_ps1 -PathType Leaf)) {
	Log 4 'Script nicht gefunden: Set-CiscoAnyConnect-DefaultProfile.ps1' -ForegroundColor Red
	Log 4 'Abbruch.' -ForegroundColor Red
	# Beenden und sicherstellen, dass der User die Meldung sieht
	Stop-Script-Wait $WaitOnEnd
}



# Elevate Script
# 200731: ExecutionPolicy übernehmen
# 200806
# 	NoExitElevatedSession
# 	PassParams
If (-NOT ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)) {
	$NoExitElevatedSession = $False
	$PassParams = $True
	# Relaunch as an elevated process
	If ($PassParams) {
		# Script-Parameter an die elevated Session weitergeben
		[String[]]$ScriptParams = $MyInvocation.BoundParameters.GetEnumerator() | 
			ForEach-Object {
				If ($_.Value -is [Switch]) { "-$($_.Key)" } Else { "-$($_.Key)", "$($_.Value)" }
			}
		$ScriptParams += $MyInvocation.UnboundArguments
	}

	# Die ExecutionPolicy übernehmen
	$MyExecutionPolicy = [String](Get-ExecutionPolicy)
	# Das Arbeitsverzeichnis übernehmen
	$WorkingDir = [IO.Path]::GetDirectoryName((Get-PSCallStack | select -ExpandProperty ScriptName))
	
	If ($NoExitElevatedSession) {
		[String[]]$PowerShellExeParams = @('-NoProfile', '-NoExit', "-ExecutionPolicy $MyExecutionPolicy", '-File', ('"{0}"' -f $MyInvocation.MyCommand.Path))
	} Else {
		[String[]]$PowerShellExeParams = @('-NoProfile', "-ExecutionPolicy $MyExecutionPolicy", '-File', ('"{0}"' -f $MyInvocation.MyCommand.Path))
	}

	$ArgumentList = $PowerShellExeParams + $ScriptParams
	# Die Datei signieren
	Start-Process -FilePath 'PowerShell.exe' -Verb RunAs -WorkingDirectory $WorkingDir -ArgumentList $ArgumentList
	Exit
}
# Now running elevated so launch the script:



## Main


Log 0 '40-10 Platziere die PowerShell-Console' 
## Das PowerShell-Fenster links positionieren
# Die Applikationsfenster-Deltas genüber dem Bildschirm berechnen
$WindowDeltas = Calc-Process-Window-Deltas
Set-Window-LeftRight -WindowDeltas $WindowDeltas -ProcessID $PID -PositionLeft


If ((Is-Chrome-Installed) -eq $False) {
	Log 4 'Wir brachen den Chrome Browser' -ForegroundColor Red
	Log 4 'Abbruch.' -ForegroundColor Red
	# Beenden und sicherstellen, dass der User die Meldung sieht
	Stop-Script-Wait $WaitOnEnd
}


# 003, 201013, tom-agplv3@jig.ch
# 	Der Chrome Cache wird nicht mehr gelöscht
# 
# Log 0 '40-15 Löschen den Chrome-Cache'
# Delete-Chrome-Browser-Cache


Log 0 '40-20 Teste die Cisco AnyConnect core-vpn-webdeploy Grundinstallation'
If ((Is-Cisco-AnyConnect-Installed) -eq $False) {
	Log 4 "Cisco core-vpn-webdeploy muss installiert sein, fehlt aber." -ForegroundColor Red
	Log 4 "Abbruch." -ForegroundColor Red
	# Beenden und sicherstellen, dass der User die Meldung sieht
	Stop-Script-Wait $WaitOnEnd
}

Log 0 '40-30 Teste die VPN-Verbindung'
Log 1 'Aktiviere die VPN-Zertifikat-Wahl'
. $SetCiscoAnyConnectDefaultProfile_ps1 -EnableAutomaticCertSelection -EnableLocalLanAccess -DisableBlockUntrustedServers

Log 1 'Haben wir eine VPN-Verbindung?'
If (Is-Cisco-Vpn-Connected-ByCertificate) {
	Log 2 'VPN-Verbindung i.O.: Bereits mit dem Zertifikat angemeldet'
} Else {
	If (Is-Cisco-Vpn-Connected) {
		Log 2 'Trenne die alte VPN-Verbindung'
		Disconnect-Cisco-Vpn
	}
	
	Log 2 'Beende die Cisco-Prozesse'
	Kill-Cisco-VPN-Processes
	
	Log 2 'Prüfe RDP'
	If (Is-RDP-Session-Active) {
		Log 3 'In der RDP-Session kann das VPN *nicht* gestartet werden' -ForegroundColor Red
		Log 3 'Bitte direkt am Host die VPN-Verbindung starten.' -ForegroundColor Red
		Start-Sleep -Milliseconds 1500
	}
	

	Log 2 'Baue die neue VPN-Verbindung auf'
	Remove-Variable -Name i -ErrorAction SilentlyContinue
	While (!(Is-Cisco-Vpn-Connected)) {
		If ($i++ % 10 -eq 0) {
			Log 0 '40-40 Bitte mit Cisco AnyConnect und dem Zertifikat(!) die VPN-Verbindung herstellen' -ForegroundColor Yellow -BackgroundColor DarkRed
			Start-Cisco-AnyConnect-UI
		}
		Start-Sleep -Milliseconds 1500
	}
	Log 2 'Verbindung OK'
}



Log 0 '40-50 Öffne die Webseite'
Start-Sleep -Milliseconds 1500
Start-Chrome-Browser $WelcomeURL

Log 1 'Warte, bis Chrome initialisiert ist und setze ihn in den Fordergrund'
Wait-For-Chrome-And-SetToForeground

Log 1 'Positioniere die Webseite'
Set-Window-LeftRight -WindowDeltas $WindowDeltas -ProcessName 'Chrome'

Log 0 '40-60 Warte auf die Webseite'
Log 1 'Cisco stiehlt den Fokus - bitte allenfalls das Chrome-Fenster anklicken' -ForegroundColor Yellow -BackgroundColor DarkRed


# Wir haben zwei Varianten:
# 1) Der Start der Geräte-Sicherheitsprüfung
# 2) Die Onboarding-Notiz, dass das Gerät bereits onboarded ist
$WinTitleSicherheitsprüfung = @('Geräte-Sicherheitsprüfung*', 'Device Security Check*', 'Contrôle de sécurité de l''appareil*')
$WinTitleOnboardingNotice = @('nosergroup onboarding notice*')

$BrowserPID, $WinTitle = Wait-For-Window ($WinTitleSicherheitsprüfung + $WinTitleOnboardingNotice) ((Get-Chrome-Browser-Exe-Info).FileName)
Log 1 'Positioniere die Webseite'
Set-Window-LeftRight -WindowDeltas $WindowDeltas -ProcessID $BrowserPID -PositionRight


# Haben wir den Onboarding-Hinweis, dass das Gerät bereits onboarded wurde?
$Res = @($WinTitleOnboardingNotice | ? { $WinTitle -match $_ })
If ($Res.Count -gt 0) {
	# Wir müssen ein Ticket erstellen:
	# If you see this notice, your device has already been added via the Nosergroup onboarding process.
	# Please open a ticket at: https://servicedesk.nosergroup.com, to have it removed.

	Print-Computer-Info
	
	# Starte das Tickt-Portal
	Start-Chrome-Browser $ServiceDeskURL
	
	# Der User muss das Fenster selber schliessen
	Do {
		$Response = Wait-For-UserInput 'Fertig?' 'Hast Du das Ticket erstellt?' @('&Ja', '&Yes', '&Nein', '&No') 'Nein'
	} Until ( @('Ja', 'Yes') -Contains $Response )
	Stop-Script-Wait 10
}



Log 0 '40-70 Starte die Geräte-Sicherheitsprüfung'
SendWait '' '{Tab}{Enter}'
Show-Countdown 10

Log 1 'Bitte nach der Geräte-Sicherheitsprüfung diesen Punkt wählen:' -ForegroundColor Yellow -BackgroundColor DarkRed
Log 1 "'Dies ist mein erster Besuch'" -ForegroundColor Yellow -BackgroundColor DarkRed

Log 0 '40-80 Bist Du bereit?'
Do {
	$Response = Wait-For-UserInput "Hast Du 'Dies ist mein erster Besuch' gestartet?" "Hast Du im Browser 'Dies ist mein erster Besuch' ausgewählt?" @('&Ja', '&Yes', '&Nein', '&No') 'Ja'
} Until ( @('Ja', 'Yes') -Contains $Response )


Log 0 '40-90 Starte das Cisco AnyConnect Setup'
If ($CiscoAnyConnectSetupExe = Get-BinDir-Newest-File $AnyConnect_Setup_ISE_NetworkAssistant) {
	Log 1 'Bitte durch die Installation klicken!' -ForegroundColor Yellow -BackgroundColor DarkRed
	Log 1 '… und den Computer noch *nicht* neu starten!' -ForegroundColor Yellow -BackgroundColor DarkRed
	Start-Sleep -Milliseconds 1500
	Start-Exe-Cloned-AndWait $CiscoAnyConnectSetupExe
}


# 40-100 Warte auf die Cisco Desktop-Links und lösche sie
Switch (Get-Computer-Owner) {
	{ @([eNoserFirma]::Akros, [eNoserFirma]::Unknown) -contains $_ } {
		Log 0 '40-100 Warte auf die Cisco Desktop-Links und lösche sie'
		Log 1 'Das dauert eine ganze Weile :-('
		Log 1 'Das Script kann hier auch abgebrochen werden.'
		Remove-Cisco-Desktop-Lnk-Files
	}
}



Switch ($WaitOnEnd) {
	0 {
		# Nichts zu tun, Script beenden
	}
	1 {
		# Pause
		Log 0 '40-110 Press any key to continue …'
		Try { $x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown") } Catch {}
	}
	Default {
		# Start-Sleep -Seconds $WaitOnEnd
		Show-Countdown $WaitOnEnd
	}
}

# SIG # Begin signature block
# MIImxAYJKoZIhvcNAQcCoIImtTCCJrECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQURm7L6TzNtj8fg17kVpUxaOiY
# eoOggh/VMIIFbzCCBFegAwIBAgIQSPyTtGBVlI02p8mKidaUFjANBgkqhkiG9w0B
# AQwFADB7MQswCQYDVQQGEwJHQjEbMBkGA1UECAwSR3JlYXRlciBNYW5jaGVzdGVy
# MRAwDgYDVQQHDAdTYWxmb3JkMRowGAYDVQQKDBFDb21vZG8gQ0EgTGltaXRlZDEh
# MB8GA1UEAwwYQUFBIENlcnRpZmljYXRlIFNlcnZpY2VzMB4XDTIxMDUyNTAwMDAw
# MFoXDTI4MTIzMTIzNTk1OVowVjELMAkGA1UEBhMCR0IxGDAWBgNVBAoTD1NlY3Rp
# Z28gTGltaXRlZDEtMCsGA1UEAxMkU2VjdGlnbyBQdWJsaWMgQ29kZSBTaWduaW5n
# IFJvb3QgUjQ2MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAjeeUEiIE
# JHQu/xYjApKKtq42haxH1CORKz7cfeIxoFFvrISR41KKteKW3tCHYySJiv/vEpM7
# fbu2ir29BX8nm2tl06UMabG8STma8W1uquSggyfamg0rUOlLW7O4ZDakfko9qXGr
# YbNzszwLDO/bM1flvjQ345cbXf0fEj2CA3bm+z9m0pQxafptszSswXp43JJQ8mTH
# qi0Eq8Nq6uAvp6fcbtfo/9ohq0C/ue4NnsbZnpnvxt4fqQx2sycgoda6/YDnAdLv
# 64IplXCN/7sVz/7RDzaiLk8ykHRGa0c1E3cFM09jLrgt4b9lpwRrGNhx+swI8m2J
# mRCxrds+LOSqGLDGBwF1Z95t6WNjHjZ/aYm+qkU+blpfj6Fby50whjDoA7NAxg0P
# OM1nqFOI+rgwZfpvx+cdsYN0aT6sxGg7seZnM5q2COCABUhA7vaCZEao9XOwBpXy
# bGWfv1VbHJxXGsd4RnxwqpQbghesh+m2yQ6BHEDWFhcp/FycGCvqRfXvvdVnTyhe
# Be6QTHrnxvTQ/PrNPjJGEyA2igTqt6oHRpwNkzoJZplYXCmjuQymMDg80EY2NXyc
# uu7D1fkKdvp+BRtAypI16dV60bV/AK6pkKrFfwGcELEW/MxuGNxvYv6mUKe4e7id
# FT/+IAx1yCJaE5UZkADpGtXChvHjjuxf9OUCAwEAAaOCARIwggEOMB8GA1UdIwQY
# MBaAFKARCiM+lvEH7OKvKe+CpX/QMKS0MB0GA1UdDgQWBBQy65Ka/zWWSC8oQEJw
# IDaRXBeF5jAOBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zATBgNVHSUE
# DDAKBggrBgEFBQcDAzAbBgNVHSAEFDASMAYGBFUdIAAwCAYGZ4EMAQQBMEMGA1Ud
# HwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwuY29tb2RvY2EuY29tL0FBQUNlcnRpZmlj
# YXRlU2VydmljZXMuY3JsMDQGCCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0
# cDovL29jc3AuY29tb2RvY2EuY29tMA0GCSqGSIb3DQEBDAUAA4IBAQASv6Hvi3Sa
# mES4aUa1qyQKDKSKZ7g6gb9Fin1SB6iNH04hhTmja14tIIa/ELiueTtTzbT72ES+
# BtlcY2fUQBaHRIZyKtYyFfUSg8L54V0RQGf2QidyxSPiAjgaTCDi2wH3zUZPJqJ8
# ZsBRNraJAlTH/Fj7bADu/pimLpWhDFMpH2/YGaZPnvesCepdgsaLr4CnvYFIUoQx
# 2jLsFeSmTD1sOXPUC4U5IOCFGmjhp0g4qdE2JXfBjRkWxYhMZn0vY86Y6GnfrDyo
# XZ3JHFuu2PMvdM+4fvbXg50RlmKarkUT2n/cR/vfw1Kf5gZV6Z2M8jpiUbzsJA8p
# 1FiAhORFe1rYMIIGGjCCBAKgAwIBAgIQYh1tDFIBnjuQeRUgiSEcCjANBgkqhkiG
# 9w0BAQwFADBWMQswCQYDVQQGEwJHQjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVk
# MS0wKwYDVQQDEyRTZWN0aWdvIFB1YmxpYyBDb2RlIFNpZ25pbmcgUm9vdCBSNDYw
# HhcNMjEwMzIyMDAwMDAwWhcNMzYwMzIxMjM1OTU5WjBUMQswCQYDVQQGEwJHQjEY
# MBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSswKQYDVQQDEyJTZWN0aWdvIFB1Ymxp
# YyBDb2RlIFNpZ25pbmcgQ0EgUjM2MIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIB
# igKCAYEAmyudU/o1P45gBkNqwM/1f/bIU1MYyM7TbH78WAeVF3llMwsRHgBGRmxD
# eEDIArCS2VCoVk4Y/8j6stIkmYV5Gej4NgNjVQ4BYoDjGMwdjioXan1hlaGFt4Wk
# 9vT0k2oWJMJjL9G//N523hAm4jF4UjrW2pvv9+hdPX8tbbAfI3v0VdJiJPFy/7Xw
# iunD7mBxNtecM6ytIdUlh08T2z7mJEXZD9OWcJkZk5wDuf2q52PN43jc4T9OkoXZ
# 0arWZVeffvMr/iiIROSCzKoDmWABDRzV/UiQ5vqsaeFaqQdzFf4ed8peNWh1OaZX
# nYvZQgWx/SXiJDRSAolRzZEZquE6cbcH747FHncs/Kzcn0Ccv2jrOW+LPmnOyB+t
# AfiWu01TPhCr9VrkxsHC5qFNxaThTG5j4/Kc+ODD2dX/fmBECELcvzUHf9shoFvr
# n35XGf2RPaNTO2uSZ6n9otv7jElspkfK9qEATHZcodp+R4q2OIypxR//YEb3fkDn
# 3UayWW9bAgMBAAGjggFkMIIBYDAfBgNVHSMEGDAWgBQy65Ka/zWWSC8oQEJwIDaR
# XBeF5jAdBgNVHQ4EFgQUDyrLIIcouOxvSK4rVKYpqhekzQwwDgYDVR0PAQH/BAQD
# AgGGMBIGA1UdEwEB/wQIMAYBAf8CAQAwEwYDVR0lBAwwCgYIKwYBBQUHAwMwGwYD
# VR0gBBQwEjAGBgRVHSAAMAgGBmeBDAEEATBLBgNVHR8ERDBCMECgPqA8hjpodHRw
# Oi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29QdWJsaWNDb2RlU2lnbmluZ1Jvb3RS
# NDYuY3JsMHsGCCsGAQUFBwEBBG8wbTBGBggrBgEFBQcwAoY6aHR0cDovL2NydC5z
# ZWN0aWdvLmNvbS9TZWN0aWdvUHVibGljQ29kZVNpZ25pbmdSb290UjQ2LnA3YzAj
# BggrBgEFBQcwAYYXaHR0cDovL29jc3Auc2VjdGlnby5jb20wDQYJKoZIhvcNAQEM
# BQADggIBAAb/guF3YzZue6EVIJsT/wT+mHVEYcNWlXHRkT+FoetAQLHI1uBy/YXK
# ZDk8+Y1LoNqHrp22AKMGxQtgCivnDHFyAQ9GXTmlk7MjcgQbDCx6mn7yIawsppWk
# vfPkKaAQsiqaT9DnMWBHVNIabGqgQSGTrQWo43MOfsPynhbz2Hyxf5XWKZpRvr3d
# MapandPfYgoZ8iDL2OR3sYztgJrbG6VZ9DoTXFm1g0Rf97Aaen1l4c+w3DC+IkwF
# kvjFV3jS49ZSc4lShKK6BrPTJYs4NG1DGzmpToTnwoqZ8fAmi2XlZnuchC4NPSZa
# PATHvNIzt+z1PHo35D/f7j2pO1S8BCysQDHCbM5Mnomnq5aYcKCsdbh0czchOm8b
# kinLrYrKpii+Tk7pwL7TjRKLXkomm5D1Umds++pip8wH2cQpf93at3VDcOK4N7Ew
# oIJB0kak6pSzEu4I64U6gZs7tS/dGNSljf2OSSnRr7KWzq03zl8l75jy+hOds9TW
# SenLbjBQUGR96cFr6lEUfAIEHVC1L68Y1GGxx4/eRI82ut83axHMViw1+sVpbPxg
# 51Tbnio1lB93079WPFnYaOvfGAA0e0zcfF/M9gXr+korwQTh2Prqooq2bYNMvUoU
# KD85gnJ+t0smrWrb8dee2CvYZXD5laGtaAxOfy/VKNmwuWuAh9kcMIIGVzCCBL+g
# AwIBAgIRAJerP2s13dPOpevRLwsJhzgwDQYJKoZIhvcNAQEMBQAwVDELMAkGA1UE
# BhMCR0IxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDErMCkGA1UEAxMiU2VjdGln
# byBQdWJsaWMgQ29kZSBTaWduaW5nIENBIFIzNjAeFw0yMjAyMjIwMDAwMDBaFw0y
# NTAyMjEyMzU5NTlaMEIxCzAJBgNVBAYTAkNIMQ0wCwYDVQQIDARCZXJuMREwDwYD
# VQQKDAhBS1JPUyBBRzERMA8GA1UEAwwIQUtST1MgQUcwggIiMA0GCSqGSIb3DQEB
# AQUAA4ICDwAwggIKAoICAQCpEHaWk6un+cfauC+UdCaWrIgc5OZFQIVVqo+wXffW
# GxD1tltMGe4tOmB2Vt+zCQl2pzJ0NZgMtO8a39023XuM0iPbp0o3OjEsWbqP4o2I
# HlJq5vhgn2cJpVDo16bwmbLywtnyNr9V2MRIh+Bil2/BeMPq+F9VHfiDaq6l0w5M
# BkOiNDSqNda+B79ShSoYcsGsYvLQfhFF5Pyh6a46SCtp/1AIaRVw3jnNJtocunCF
# ni7kb1UJP2Q16TEPo3lCxicyZWK0nof+o9KDmUOC84Tj6eat6dodXsW4vyOhoEYZ
# N2CprNBq7Q5crwWOTKNwz3+vNEOmlQlCqSIlrIKOFzBzDp3U2o9to+I8A9rsqY63
# BDrJFVq5KKe2DBRYwBZ5e7B9+MqS0Ug930xZBSDHQQ3DvvOEQgF7fKRQt1/X1g8T
# GO37MmN6sHd31OeM1kbx8lMM4f+DqegGD7IB6N8wKgnOazelyQXni38APNi/fpFA
# xixsFldvmI4Z8QoYqXsEiLDD05JKhUqpgITpRd8gLUiBuzOWs58FEXhx3X1C37iT
# TgyhBP7v4PUWWqe8KWukSPImE4J7y+1cJ7GqOPSLwkLgTuNm/Ko7wJyWfD4/LPNb
# O0a9YEHUTqbHoKIy55sIl7cmaaia5uz1Uzr3hzSVoVu1TwJl9qHdTQOM8/YnG7wQ
# 5wIDAQABo4IBtDCCAbAwHwYDVR0jBBgwFoAUDyrLIIcouOxvSK4rVKYpqhekzQww
# HQYDVR0OBBYEFBm6ziTh2H5Wi50vwBGP3n71Vh8FMA4GA1UdDwEB/wQEAwIHgDAM
# BgNVHRMBAf8EAjAAMBMGA1UdJQQMMAoGCCsGAQUFBwMDMBEGCWCGSAGG+EIBAQQE
# AwIEEDBKBgNVHSAEQzBBMDUGDCsGAQQBsjEBAgEDAjAlMCMGCCsGAQUFBwIBFhdo
# dHRwczovL3NlY3RpZ28uY29tL0NQUzAIBgZngQwBBAEwSQYDVR0fBEIwQDA+oDyg
# OoY4aHR0cDovL2NybC5zZWN0aWdvLmNvbS9TZWN0aWdvUHVibGljQ29kZVNpZ25p
# bmdDQVIzNi5jcmwweQYIKwYBBQUHAQEEbTBrMEQGCCsGAQUFBzAChjhodHRwOi8v
# Y3J0LnNlY3RpZ28uY29tL1NlY3RpZ29QdWJsaWNDb2RlU2lnbmluZ0NBUjM2LmNy
# dDAjBggrBgEFBQcwAYYXaHR0cDovL29jc3Auc2VjdGlnby5jb20wFgYDVR0RBA8w
# DYELaXRAYWtyb3MuY2gwDQYJKoZIhvcNAQEMBQADggGBAFGyk9DeEOqnhYFNzxZ7
# HrS40+MelZjeyazVlzG5NfBIzxse6fpiP9C6f0zL//HrrjSkl9UyFNmn+5TfL/kw
# N40hogdDkna7DrsKxLQ1viBFLdJBxjg8Nz0KVgtcbUpi1Qj3H6UI4skLdUSir1iE
# oSR+QGkNzSJSrn2k8jijSMOYldbngzG+D9PzSNp/CjBCA1bTOBepuHVQQCl/5rY1
# bygvNL7Zua/Ca6iuxnAsJOisw9IkngKi3iznXTHQep0ytOOOvZhr3IRkOccy/cyz
# 9KA1jv68aKCsLiGpyUKCg8WqmwzLXCUfqxvouhrHr1yAYn2qHRRoQhiIw8TgghlE
# +PA9qKY6KIlmilX7VejuFScmrBQVkP0OuxLTufXIahY2jnPQfrJLz0U+fUL1YgHa
# 1oi+1rOZ/Z0iX2YXa1rDmrXueN8QNOtZuBEKBKUNSSq8hhH4rk2j7dVcYm1gljkd
# CR8vwGRBoj9oMJgehkTdMU9GAGu9Ny9COnT/J9mRc323HzCCBuwwggTUoAMCAQIC
# EDAPb6zdZph0fKlGNqd4LbkwDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVT
# MRMwEQYDVQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtKZXJzZXkgQ2l0eTEeMBwG
# A1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3Qg
# UlNBIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE5MDUwMjAwMDAwMFoXDTM4
# MDExODIzNTk1OVowfTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFu
# Y2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1p
# dGVkMSUwIwYDVQQDExxTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5nIENBMIICIjAN
# BgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAyBsBr9ksfoiZfQGYPyCQvZyAIVST
# uc+gPlPvs1rAdtYaBKXOR4O168TMSTTL80VlufmnZBYmCfvVMlJ5LsljwhObtoY/
# AQWSZm8hq9VxEHmH9EYqzcRaydvXXUlNclYP3MnjU5g6Kh78zlhJ07/zObu5pCNC
# rNAVw3+eolzXOPEWsnDTo8Tfs8VyrC4Kd/wNlFK3/B+VcyQ9ASi8Dw1Ps5EBjm6d
# J3VV0Rc7NCF7lwGUr3+Az9ERCleEyX9W4L1GnIK+lJ2/tCCwYH64TfUNP9vQ6oWM
# ilZx0S2UTMiMPNMUopy9Jv/TUyDHYGmbWApU9AXn/TGs+ciFF8e4KRmkKS9G493b
# kV+fPzY+DjBnK0a3Na+WvtpMYMyou58NFNQYxDCYdIIhz2JWtSFzEh79qsoIWId3
# pBXrGVX/0DlULSbuRRo6b83XhPDX8CjFT2SDAtT74t7xvAIo9G3aJ4oG0paH3uhr
# DvBbfel2aZMgHEqXLHcZK5OVmJyXnuuOwXhWxkQl3wYSmgYtnwNe/YOiU2fKsfqN
# oWTJiJJZy6hGwMnypv99V9sSdvqKQSTUG/xypRSi1K1DHKRJi0E5FAMeKfobpSKu
# pcNNgtCN2mu32/cYQFdz8HGj+0p9RTbB942C+rnJDVOAffq2OVgy728YUInXT50z
# vRq1naHelUF6p4MCAwEAAaOCAVowggFWMB8GA1UdIwQYMBaAFFN5v1qqK0rPVIDh
# 2JvAnfKyA2bLMB0GA1UdDgQWBBQaofhhGSAPw0F3RSiO0TVfBhIEVTAOBgNVHQ8B
# Af8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADATBgNVHSUEDDAKBggrBgEFBQcD
# CDARBgNVHSAECjAIMAYGBFUdIAAwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2Ny
# bC51c2VydHJ1c3QuY29tL1VTRVJUcnVzdFJTQUNlcnRpZmljYXRpb25BdXRob3Jp
# dHkuY3JsMHYGCCsGAQUFBwEBBGowaDA/BggrBgEFBQcwAoYzaHR0cDovL2NydC51
# c2VydHJ1c3QuY29tL1VTRVJUcnVzdFJTQUFkZFRydXN0Q0EuY3J0MCUGCCsGAQUF
# BzABhhlodHRwOi8vb2NzcC51c2VydHJ1c3QuY29tMA0GCSqGSIb3DQEBDAUAA4IC
# AQBtVIGlM10W4bVTgZF13wN6MgstJYQRsrDbKn0qBfW8Oyf0WqC5SVmQKWxhy7VQ
# 2+J9+Z8A70DDrdPi5Fb5WEHP8ULlEH3/sHQfj8ZcCfkzXuqgHCZYXPO0EQ/V1cPi
# vNVYeL9IduFEZ22PsEMQD43k+ThivxMBxYWjTMXMslMwlaTW9JZWCLjNXH8Blr5y
# Umo7Qjd8Fng5k5OUm7Hcsm1BbWfNyW+QPX9FcsEbI9bCVYRm5LPFZgb289ZLXq2j
# K0KKIZL+qG9aJXBigXNjXqC72NzXStM9r4MGOBIdJIct5PwC1j53BLwENrXnd8uc
# Lo0jGLmjwkcd8F3WoXNXBWiap8k3ZR2+6rzYQoNDBaWLpgn/0aGUpk6qPQn1BWy3
# 0mRa2Coiwkud8TleTN5IPZs0lpoJX47997FSkc4/ifYcobWpdR9xv1tDXWU9UIFu
# q/DQ0/yysx+2mZYm9Dx5i1xkzM3uJ5rloMAMcofBbk1a0x7q8ETmMm8c6xdOlMN4
# ZSA7D0GqH+mhQZ3+sbigZSo04N6o+TzmwTC7wKBjLPxcFgCo0MR/6hGdHgbGpm0y
# XbQ4CStJB6r97DDa8acvz7f9+tCjhNknnvsBZne5VhDhIG7GrrH5trrINV0zdo7x
# fCAMKneutaIChrop7rRaALGMq+P5CslUXdS5anSevUiumDCCBvUwggTdoAMCAQIC
# EDlMJeF8oG0nqGXiO9kdItQwDQYJKoZIhvcNAQEMBQAwfTELMAkGA1UEBhMCR0Ix
# GzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEY
# MBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSUwIwYDVQQDExxTZWN0aWdvIFJTQSBU
# aW1lIFN0YW1waW5nIENBMB4XDTIzMDUwMzAwMDAwMFoXDTM0MDgwMjIzNTk1OVow
# ajELMAkGA1UEBhMCR0IxEzARBgNVBAgTCk1hbmNoZXN0ZXIxGDAWBgNVBAoTD1Nl
# Y3RpZ28gTGltaXRlZDEsMCoGA1UEAwwjU2VjdGlnbyBSU0EgVGltZSBTdGFtcGlu
# ZyBTaWduZXIgIzQwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCkkyhS
# S88nh3akKRyZOMDnDtTRHOxoywFk5IrNd7BxZYK8n/yLu7uVmPslEY5aiAlmERRY
# sroiW+b2MvFdLcB6og7g4FZk7aHlgSByIGRBbMfDCPrzfV3vIZrCftcsw7oRmB78
# 0yAIQrNfv3+IWDKrMLPYjHqWShkTXKz856vpHBYusLA4lUrPhVCrZwMlobs46Q9v
# qVqakSgTNbkf8z3hJMhrsZnoDe+7TeU9jFQDkdD8Lc9VMzh6CRwH0SLgY4anvv3S
# g3MSFJuaTAlGvTS84UtQe3LgW/0Zux88ahl7brstRCq+PEzMrIoEk8ZXhqBzNiuB
# l/obm36Ih9hSeYn+bnc317tQn/oYJU8T8l58qbEgWimro0KHd+D0TAJI3VilU6aj
# oO0ZlmUVKcXtMzAl5paDgZr2YGaQWAeAzUJ1rPu0kdDF3QFAaraoEO72jXq3nnWv
# 06VLGKEMn1ewXiVHkXTNdRLRnG/kXg2b7HUm7v7T9ZIvUoXo2kRRKqLMAMqHZkOj
# GwDvorWWnWKtJwvyG0rJw5RCN4gghKiHrsO6I3J7+FTv+GsnsIX1p0OF2Cs5dNta
# dwLRpPr1zZw9zB+uUdB7bNgdLRFCU3F0wuU1qi1SEtklz/DT0JFDEtcyfZhs43dB
# yP8fJFTvbq3GPlV78VyHOmTxYEsFT++5L+wJEwIDAQABo4IBgjCCAX4wHwYDVR0j
# BBgwFoAUGqH4YRkgD8NBd0UojtE1XwYSBFUwHQYDVR0OBBYEFAMPMciRKpO9Y/PR
# XU2kNA/SlQEYMA4GA1UdDwEB/wQEAwIGwDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB
# /wQMMAoGCCsGAQUFBwMIMEoGA1UdIARDMEEwNQYMKwYBBAGyMQECAQMIMCUwIwYI
# KwYBBQUHAgEWF2h0dHBzOi8vc2VjdGlnby5jb20vQ1BTMAgGBmeBDAEEAjBEBgNV
# HR8EPTA7MDmgN6A1hjNodHRwOi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29SU0FU
# aW1lU3RhbXBpbmdDQS5jcmwwdAYIKwYBBQUHAQEEaDBmMD8GCCsGAQUFBzAChjNo
# dHRwOi8vY3J0LnNlY3RpZ28uY29tL1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5j
# cnQwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNlY3RpZ28uY29tMA0GCSqGSIb3
# DQEBDAUAA4ICAQBMm2VY+uB5z+8VwzJt3jOR63dY4uu9y0o8dd5+lG3DIscEld9l
# aWETDPYMnvWJIF7Bh8cDJMrHpfAm3/j4MWUN4OttUVemjIRSCEYcKsLe8tqKRfO+
# 9/YuxH7t+O1ov3pWSOlh5Zo5d7y+upFkiHX/XYUWNCfSKcv/7S3a/76TDOxtog3M
# w/FuvSGRGiMAUq2X1GJ4KoR5qNc9rCGPcMMkeTqX8Q2jo1tT2KsAulj7NYBPXyhx
# bBlewoNykK7gxtjymfvqtJJlfAd8NUQdrVgYa2L73mzECqls0yFGcNwvjXVMI8JB
# 0HqWO8NL3c2SJnR2XDegmiSeTl9O048P5RNPWURlS0Nkz0j4Z2e5Tb/MDbE6MNCh
# PUitemXk7N/gAfCzKko5rMGk+al9NdAyQKCxGSoYIbLIfQVxGksnNqrgmByDdefH
# fkuEQ81D+5CXdioSrEDBcFuZCkD6gG2UYXvIbrnIZ2ckXFCNASDeB/cB1PguEc2d
# g+X4yiUcRD0n5bCGRyoLG4R2fXtoT4239xO07aAt7nMP2RC6nZksfNd1H48QxJTm
# fiTllUqIjCfWhWYd+a5kdpHoSP7IVQrtKcMf3jimwBT7Mj34qYNiNsjDvgCHHKv6
# SkIciQPc9Vx8cNldeE7un14g5glqfCsIo0j1FfwET9/NIRx65fWOGtS5QDGCBlkw
# ggZVAgEBMGkwVDELMAkGA1UEBhMCR0IxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRl
# ZDErMCkGA1UEAxMiU2VjdGlnbyBQdWJsaWMgQ29kZSBTaWduaW5nIENBIFIzNgIR
# AJerP2s13dPOpevRLwsJhzgwCQYFKw4DAhoFAKB4MBgGCisGAQQBgjcCAQwxCjAI
# oAKAAKECgAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIB
# CzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFJJMZGjcwrrp6cVN7Mv+
# uHloUQS4MA0GCSqGSIb3DQEBAQUABIICAGOWhA6WfNNJ95YlV/IRvt30AUsjgUUm
# sFy6SaFh86zsV+rWx5WpDOXK3UKb3QXq63VjW//gJpNzHH3aLuKdpynsa08EuApd
# hu54Dxe6aYax3n2CE2KGtrFK6cI4NaiGrE9bmhlYbsxKwiwnf8FRD0RdI8ndtOLK
# UFp/rb9aL7cph/nrl8X3/WwPbrLXkuKWHEqLr6pWQlcF8Jjdd849lKklLXiqgC/J
# scFI/nwvvORqbUH/fSqriREfCEIPG7Hs/ZrHcL615o8awvCbkJbz2c27b+2GCKmx
# h4JDr1cF6YY31blAcBxesPkxxigxkw1TJUmpK/KRmrX30qaGLQkI6+SMo7eQ0s0g
# y9noQ2rAauUREkdaew1ruyizJpM2jAUXaakA5BBn0TskX0M4ZYrr+KzgL0vIttAn
# aORI4YU+TF5sXwW8mYIoPnUjfxhOY/LAX+PLQ+fz/Eju3nZDty+mk8jTzqoKvF3F
# 5qC9vilOHkQ4WC1k0HA99mvdyqzmwWD7q9UPt2HY/y0OKSCpvI6AVKYvJEZ2196J
# CgPm596tkI7LHlD/en+esLf7pCtgXQmBjU4byCEJEI1sm4nsiqpWq1Oy+6lbTsUb
# 19uj7pY51AAMyMPMSh8+MpBmGClE7jaqdIvey6GD+BebVfawBwpmeaiwJNcmMGzb
# YjC9e/C6rTaIoYIDSzCCA0cGCSqGSIb3DQEJBjGCAzgwggM0AgEBMIGRMH0xCzAJ
# BgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcT
# B1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2Vj
# dGlnbyBSU0EgVGltZSBTdGFtcGluZyBDQQIQOUwl4XygbSeoZeI72R0i1DANBglg
# hkgBZQMEAgIFAKB5MBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcN
# AQkFMQ8XDTIzMDcwMzA4MDgxOVowPwYJKoZIhvcNAQkEMTIEMJqHNDZzaY8EDm7f
# EdGtSJ/YASD4iHr1L0dW972pNkLK1mwpHVKi+wRq5OaHorLzqzANBgkqhkiG9w0B
# AQEFAASCAgAHpMebNJ0ECDUHmCZtBf68bj0ybeagCPnIbr1wZYNLuQ14nJL5rE1M
# JXNtGC/r4CorgnbGA1PZ5K0hGEQmJXD6QzCNVaUobNlAzxfoscY6XOPRIyMQqVCA
# i+ZFGvtz8SUalIhBzhms1nUbRUflhoukU+y4qMAQxB6KulIKEsCIQvHMsiulmK4K
# iDurKhkiiRJzIa4w9HS8uVEtsUsQbhNmqp3jH1a7UnA7BXMw1Wi1STt71lSBbqWh
# DIc9JYpBxZ6LssIQyKEocDOK2nmuhhN7JN3hx7OmIzz4dJnQWK+g6KefHAsgtIdu
# Em+JGfaHiEcBTDIIeQcajXFmEg/LjdZQaghV4zx+5XhJLOm4Sm9U+R9w7x8SwudB
# gc7oMm0ZAwBVGYiUexx7Ud6dDd4fjNJ4PYrT+OqMIs0xwNq5sn9Q28XpWMUbd3ox
# BcvybHwLQHT5c+iZEKTAbar+xFdtMRrG/raH72p1n7OtJklyrGxbz37VgmlfpP+l
# lwsshmBe7h1xIv8X1uDXNfOkTRHFBhZ9OtIcjm1uYmOMtOX/vOMOotBp12mu0EXp
# oZ18X5jmysHu9CsSmLBpn/xjDwhilocWWg3L9TMl39eMyE/dcDa6WuztmdKpW19M
# 0gnEFS3v85p2n0MVIEPfVNDrtuc+K5XNy7eZtL77HekpFkcS/HWi4g==
# SIG # End signature block
